<!DOCTYPE html>
<html lang="en">
<?php
$title = "Videos";
include "./helpers/utils.php";
include "./layouts/header.php";
?>

<body>
    <?php include "./layouts/navbar.php"; ?>

    <?php
    include './widgets/breadcrumb.php';
    ?>
    <div class="container-xxl py-6 gallery">
        <div class="container">
            <div class="text-center mx-auto mb-5 wow fadeInUp" data-wow-delay="0.1s" style="max-width: 500px;">
                <h6 class="text-primary text-uppercase mb-2">Our Playlists</h6>
                <h1 class="display-6 mb-4">Our Playlist</h1>
            </div>
            <div class="row g-0 videos">
                <?php
                include "./helpers/configs.php";
                $query = $db->query("SELECT * FROM `video` WHERE `status`='1' ORDER BY `id` DESC");
                if ($query->num_rows > 0) {
                    while ($row = $query->fetch_assoc()) {
                        $d = json_decode($row["details"]);
                        echo '<div style="cursor: pointer" class="col-md-4 videos" data-video="' . $d->video . '" data-id="' . $row["id"] . '">
                                <div class="card">
                                    <img style="width: 100%;border-radius: 8px" class="card-img-top" src="https://img.youtube.com/vi/' . $d->video . '/maxresdefault.jpg">
                                    <div class="card-body">
                                        <a class="card-title">' . $d->title . '</a>
                                    </div>
                                </div>
                            </div>';
                    }
                }
                ?>
            </div>
        </div>
    </div>
    <div class="modal fade video-modal" role="dialog">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5></h5>
                </div>
                <div class="modal-body">
                    <div class="embed-responsive embed-responsive-16by9">
                    </div>
                </div>
                <div class="modal-footer video-closer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <?php
    include "./layouts/footer.php";
    include "./layouts/scripts.php";
    ?>

    <script>
        $('document').ready(() => {
            $('.videos').each(function() {
                $(this).find('.card-title').click(() => {
                    console.log('cli')
                    $('.video-modal .modal-header h5').html($(this).find('.card-title').html());
                    $('.video-modal .modal-body').html(
                        `<iframe style="width: 100%;height: 280px;border-radius: 8px;" src="https://www.youtube.com/embed/${$(this).data('video')}"
                        frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                        allowfullscreen></iframe>`
                    );
                    $('.video-modal').modal('show');
                })
            });
            $('.video-closer').click(() => {
                $('.video-modal .modal-body').html('');
                $('.video-modal').modal('hide');
            })
        })
    </script>

</body>

</html>