<style>
.table-responsive {
    display: block;
    width: 100%;
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
    -ms-overflow-style: -ms-autohiding-scrollbar;
}

.table {
    width: 100%;
    max-width: 100%;
    margin-bottom: 1rem;
    background-color: transparent;
    border: 2px solid #000000;
}

th,
td {
    border-left: 2px solid #000000;
    border-bottom: 2px solid #000000;
    border-top: none;
    border-right: 2px solid #000000;
    padding: 5px;
}

th {
    background-color: var(--secondary) !important;
    color: #220202;
    border: 2px solid #060606;
    text-align: center;
}

td {
    border: 2px solid #060606;
    text-align: center;
    font-weight: bold;
    vertical-align: middle;
}

.sub td {
    background-color: #3a3030;
}

.glow {
    color: #fff;
    font-size: 18px;
    font-family: "ubuntu";
    text-transform: uppercase;
    font-weight: 700;
    font-family: "Josefin Sans", sans-serif;
    /* background: linear-gradient(to right, #1a0104 10%, #e03838 50%, #4a0412 60%); */
    /* background-size: auto auto;
    background-clip: border-box;
    background-size: 200% auto; */
    color: #fff;
    background-clip: text;
    /* text-fill-color: transparent;
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent; */
    animation: textclip 1.5s linear infinite;
    display: inline-block;
}

td {
    color: #000;
}

.odd td {
    background-color: #d2cfcf;
}

.even td {
    background-color: #827d7d;
}

td.product_rate {
    color: #000;
}

td.product_image img,
td.product_video img.youtube {
    max-width: 60px;
    max-height: 60px;
    cursor: pointer;
}

td.product_name {
    width: 38%;
}

@media only screen and (max-width: 767px) {

    .list-view th,
    .list-view td {
        padding: 8px 3px !important;
    }
}

@media only screen and (max-width: 740px) {
    td input {
        width: 50px !important;
    }
}

@media only screen and (max-width: 700px) {
    .product-logo img {
        width: 20px !important;
        height: 20px !important;
    }
}

@media only screen and (max-width: 560px) {

    .list-view th,
    .list-view td {
        font-size: 10px !important;
    }
}

@media only screen and (max-width: 412px) {

    .list-view th,
    .list-view td {
        font-size: 9px !important;
    }
}

@media only screen and (max-width: 370px) {

    .list-view th,
    .list-view td {
        font-size: 7px !important;
    }
}
</style>
<div class="table-responsive">
    <table cellpadding="0" cellspacing="0" class="table list-view">
        <tr>
            <th class="product_image">Image</th>
            <th class="product_name">Product Name</th>
            <th class="product_rate">Type</th>
            <th class="product_rate">Actual Price</th>
            <th class="discounted_price ">Amount</th>
            <th class="num-pallets">Quantity</th>
            <th class="row-total">Total</th>
        </tr>
        <?php
            $query2 = $db->query("SELECT * FROM `category` WHERE `status`='1' ORDER BY `order` ASC");
            if($query2->num_rows > 0){
                while($cat = $query2->fetch_assoc()){
                    $disp = true;
                    $query = $db->query("SELECT * FROM `product` WHERE `status`='1' AND `details` LIKE '%".$cat["title"]."%' ORDER BY `order` ASC");
                    $cl = 1;
                    if($query->num_rows > 0){
                        while($row = $query->fetch_assoc()){
                            $d = isset($row["details"]) ? json_decode(preg_replace('/[[:cntrl:]]/','<br/>',$row["details"])) : [];
                            $p = ((int)$d->retail_price) - (((int)$d->retail_price * (int)$cat["discount"]) / 100);
                            if($d->category == $cat["title"]){
                                $logo = isset($d->logo) && ($d->logo != '') ? $d->logo : $l;
                                $price = ((float)$d->retail_price) - (((float)$d->retail_price * (float)$cat["discount"]) / 100);
                                if($disp == true){
                                    echo '<tr class="sub"><td colspan="10"> 
                                        <span class="glow"> '.$cat["title"].'</span>
                                    </td></tr>';
                                    $disp = false;
                                }
                                echo '<tr class="'.($cl == 1 ? 'odd' : 'even').' product" data-image="'.$logo.'" data-discount="'.$cat["discount"].'" data-video="'.$d->url.'" data-cat="'.$cat["title"].'" data-id="'.$row["id"].'">
                                    <td class="product_image '.(isset($d->logo) && ($d->logo != '') ? 'product-logo' : '').'" style="cursor: pointer;">
                                        <img
                                            data-image="'.$logo.'"
                                            src="'.$admin.'image?src='.$logo.'&w=60&h=60&zc=2" 
                                            onerror="this.onerror=null; this.src=\''.$l.'\'" 
                                            alt="'.$d->name.' | '.$n.'" />
                                    </td>
                                    <td class="product_name name product-title name">'.$d->name.'</td>
                                    <td class="product_content type hidden-xs">'.$d->type.'</td>
                                    <td class="product_rate"> 
                                        <span class="strikeout ">Rs.'.number_format($d->retail_price,2).'</span>
                                    </td>
                                    <td class="price-per-pallet">
                                        Rs. <span class="price">'.number_format($price,2).'</span>
                                    </td>
                                    <td class="num-pallets">
                                        <input type="number" name="quantity" value="" class="num-pallets-input input-number">
                                    </td>
                                    <td class="row-total">
                                        <input type="text" name="total" value="" class="row-total-input total" disabled="disabled">
                                    </td>
                                </tr>';
                                $cl = $cl === 1 ? 2 : 1;
                            }
                        }
                    }
                }
            }
        ?>
    </table>
</div>