<style>
.panel {
    margin-bottom: 1em !important;
    background-color: #fff;
    border: none;
    border-radius: 4px;
    -webkit-box-shadow: 0 1px 1px rgb(0 0 0 / 5%);
    box-shadow: 0 1px 1px rgb(0 0 0 / 5%);
}

.panel-body {
    border: 1px solid var(--primary-color);
    position: relative;
    padding: 0 !important;
    display: flex;
    align-items: center;
    font-weight: 700;
    outline: none !important;
    font-size: 14px;
    background: #ffeeee;
    border-radius: 8px;
    box-shadow: 1px 2px 4px #0000003d;
    color: #000;
}

.product-logo {
    position: relative;
    display: inline-block;
    width: 109px;
}

.product-logo img {
    width: 100px;
    object-fit: cover;
}

.panel-flex {
    position: relative;
    margin-top: 3px;
    padding: 1em 4px;
    padding-left: 30px !important;
    width: calc(100% - 100px);
}

.panel .panel-body a {
    min-width: 100px;
    position: relative;
}

.name {
    font-size: 18px;
    margin: 0;
    position: relative;
    color: var(--primary-color) !important;
    white-space: nowrap;
    text-overflow: ellipsis;
}

.number {
    width: 45px !important;
    text-align: center;
    border-radius: 0;
    height: 25px;
    color: #333333;
    border: 2px solid #000;
}

.badge {
    color: #d32f2f;
    font-size: 14px;
}

button#q-add,
button#q-sub {
    background: #F44336;
    outline: none;
    width: 25px;
    height: 25px;
    border: none;
    border-radius: 0;
    color: #fff;
    font-weight: bolder;
}

@media (min-width: 992px) {
    .col-md-4.product {
        width: 33.33%;
    }
}

@media (max-width: 992px) {
    .col-md-4.product {
        width: 50%;
        padding: 0 8px;
    }
}

@media (max-width: 770px) {
    .col-md-4.product {
        width: 100%;
        padding: 0 8px;
    }
}

@media (max-width: 640px) {
    .name {
        font-size: 14px;
    }
}

@media (min-width: 360px) {
    .detail {
        text-align: right;
        margin-bottom: 0.1em;
    }

}

@media (max-width: 360px) {
    .panel-flex {
        padding-left: 10px !important;
    }
    .detail {
        flex-direction: column;
    }
    .detail > *{
        
    }
    .detail .badge{
        text-align: start;
    }
}
</style>

<?php
    $cou = 1;
    $cats = [];
    $query2 = $db->query("SELECT * FROM `category` WHERE `status`='1' ORDER BY `order` ASC");
    if($query2->num_rows > 0){
        while($cat = $query2->fetch_assoc()){
            $disp = true;
            $query = $db->query("SELECT * FROM `product` WHERE `status`='1' AND `details` LIKE '%".$cat["title"]."%' ORDER BY `order` ASC");
            if($query->num_rows > 0){
                while($row = $query->fetch_assoc()){
                    $d = isset($row["details"]) ? json_decode(preg_replace('/[[:cntrl:]]/','<br/>',$row["details"])) : [];
                    $p = ((int)$d->retail_price) - (((int)$d->retail_price * (int)$cat["discount"]) / 100);
                    if((isset($d->category)) && $d->category == $cat["title"]){
                        $logo = isset($d->logo) && ($d->logo != '') ? $d->logo : $l;
                        $price = ((int)$d->retail_price) - (((int)$d->retail_price * (int)$cat["discount"]) / 100);
                        if($disp == true){
                            echo '<div class="cats-sec '.str_replace(' ','-',strtolower($cat["title"])).'"><h5 class="cat-title">'.$cat["title"].'</h5>';
                            $disp = false;
                            $cats[] = $cat["title"];
                            echo '<div class="row grid">';
                        }
                        $resized_logo = 'https://siteadmin.in/image?src='.$logo.'&w=100&h=100&zc=2';
                        echo '<div class="col-xl-4 col-lg-6 col-md-6 col-12 product" data-img="'.$logo.'" data-url="'.$d->url.'" data-discount="'.$cat["discount"].'" data-cat="'.$cat["title"].'" data-id="'.$row["id"].'">
                            <div class="panel panel-theme panel-primary">
                                <input name="total" type="hidden" />
                                <div class="panel-body">
                                    <div class="product-logo" data-lightbox="picture'.($cou++).'">
                                        <img loading="lazy" data-image="'.$logo.'" class="img order-img" src="'.$resized_logo.'" alt="'.$d->name.' Image" onerror="this.onerror=null; this.src=\''.$l.'\'" >
                                    </div>
                                    <div class="panel-flex my-2" style="padding: 0 6px;">
                                        <div class="row">
                                            <div class="col-12" title="'.$d->name.'">
                                                <p class="name">'.$d->name.'</p>
                                                <button class="minus" id="q-sub"> - </button>
                                                <input name="quantity" class="input-number number" type="number">
                                                <button class="plus" id="q-add"> + </button>
                                            </div>
                                            <div class="col-12 pt-2">
                                                <div class="d-flex detail">
                                                    <del class="tab-left" id="price">Rs. '.(number_format($d->retail_price,2)).'</del>
                                                    <div>
                                                        <span class="badge p-0" id="dis-price">Rs. <span class="price">'.(number_format($price,2)).'</span></span><span
                                                        class="badge-pkt"> / '.($d->type).' </span>
                                                    </div>
                                                </div>
                                            </div>
                                            '.( isset($d->url) && ($d->url != '')  ? '<i class="video fa fa-youtube-play"></i>' : '' ).'
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>';
                    }
                }
                if($disp == false){
                    echo '</div> </div>';
                }
            }
        }
    }