<style>
.row.products:before {
    display: none;
}

.products {
    display: flex;
    column-gap: 26px;
    flex-wrap: wrap;
    flex: 1;
    justify-content: flex-start;
    align-items: center;
    margin: auto;
}

h3.title {
    text-align: center;
    color: #605c5c;
    font-size: 16px;
    font-weight: 600;
    letter-spacing: 1px;
    border-bottom: 1px solid #0000000f;
    padding-bottom: 10px;
    margin-bottom: 20px;
}

.products .product {
    border: 3px solid var(--primary-color);
    padding: 10px;
    margin: 10px 0;
    border-radius: 8px;
    box-shadow: 0 0 5px 4px #f1151512;
    width: 200px;
    background: #fff;
}

.products .product img {
    width: 100%;
    height: 180px;
    object-fit: contain;
}

.products .product h2 {
    font-weight: 600;
    text-overflow: ellipsis;
    white-space: nowrap;
    overflow: hidden;
    font-size: 14px;
    letter-spacing: 0.5px;
}

.products h3 {
    font-weight: 600;
    font-size: 12px;
}

.products .product .ctrl {
    display: flex;
    margin-bottom: 8px;
}

.products .product .ctrl button {
    background: var(--primary-color);
    border: none;
    color: #fff;
    font-weight: 600;
    font-size: 30px;
    border-radius: 0px;
    padding: 0 10px;

}

.products .product .ctrl input {
    border: 3px solid var(--primary-color);
    border-radius: 0px;
    text-indent: 10px;
    color: #000;
    width: 100%;
    font-weight: 600;

}

.products .product .infos {
    display: flex;
    justify-content: space-between;
}

.products .product .infos h3 {
    margin: 0;
    line-height: normal;
}

.cart-button {
    position: fixed;
    bottom: 50px;
    opacity: 0;
    visibility: hidden;
    text-align: center;
    cursor: pointer;
    padding: 20px 40px 10px 40px;
    left: 100%;
    transform: translateX(-100%);
    font-weight: 600;
    border-radius: 18px 18px 0 0;
    display: flex;
    flex-direction: column;
    transition: all .8s;
    z-index: 99;
}

.cart-button i {
    background: #3cbadf;
    padding: 10px;
    border-radius: 50px;
    color: #fff;
}

.cart-button.show-cart {
    visibility: visible;
    opacity: 1;
}

.input-group .input-group-btn-vertical {
    display: none;
}

/* .cart-button:hover {
        height: 20%;
    } */

.cart-button img {
    padding: 18px;
    background: #3cbadf;
    border-radius: 60px;
    box-shadow: 1px 1px 8px 4px #00000047;
    border-radius: 60px;
}

@media (max-width: 1200px) {
    .products .product h2 {
        font-size: 13px;
    }
}

@media screen and (max-width: 715px) {
    .products .product {
        width: 47%;
    }

    .products .product h2 {
        font-size: 12px;
    }

    .products .product img {
        height: 120px;
    }

    .whatsapp,
    .mobile {
        display: none;
    }
}

@media screen and (max-width: 480px) {
    .products .product {
        width: 45%;
    }
}

@media screen and (max-width: 380px) {
    .products .product {
        width: 45%;
    }

    .products .product img {
        height: 80px;
    }
}
</style>

<?php 
    $query2 = $db->query("SELECT * FROM `category` WHERE `status`='1' ORDER BY `order` ASC");
    if($query2->num_rows > 0)
    {
        while($cat = $query2->fetch_assoc())
        {
            $a = true;
            $query = $db->query("SELECT * FROM `product` WHERE `status`='1' ");
            if($query->num_rows > 0)
            {
                while($row = $query->fetch_assoc())
                {
                    $d = isset($row["details"]) ? json_decode(preg_replace('/[[:cntrl:]]/','<br/>',$row["details"])) : [];
                    $p = ((int)$d->retail_price) - (((int)$d->retail_price * (int)$cat["discount"]) / 100);
                    if($d->category == $cat["title"]){
                        $logo = isset($d->logo) && ($d->logo != '') ? $d->logo : $l;
                        $price = ((int)$d->retail_price) - (((int)$d->retail_price * (int)$cat["discount"]) / 100);
                        if($a == true){
                            echo '<h3 class="title">'.$cat["title"].'</h3>
                            <div class="row products">';
                            $a = false;
                        }
                        echo '<div class="product" data-image="'.$logo.'" data-url="'.$d->url.'" data-discount="'.$cat["discount"].'" data-cat="'.$cat["title"].'" data-id="'.$row["id"].'">
                            <input name="total" type="hidden" />
                            <img title="Click Image to preview original image" src="'.$logo.'" data-image="'.$logo.'" onerror="this.onerror=null; this.src=\''.$l.'\'" alt="'.$d->name.' Image">
                            <div style="display: flex;align-items: center;justify-content: space-between;">
                                <h2 class="name" title="'.$d->name.'">'.$d->name.'</h2>'.
                                (isset($d->url) && $d->url != '' ? '<i class="fa fa-youtube-play"></i>' : '')
                            .'</div>
                            <div class="ctrl">
                                <button class="minus">-</button>
                                <input type="number" value="0" name="quantity">
                                <button class="plus">+</button>
                            </div>
                            <div class="infos">
                                <h3 style="text-align: start;background: #605c5c;color: #fff;padding: 0 2px;border-radius: 2px;">Per <br/><b>'.$d->type.'</b></h3>
                                <h3 style="text-align: end"> <s>Rs. '.number_format((int)$d->retail_price,2).'</s><br/> Rs. <b class="price">'.number_format($price,2).'</b></h3>
                            </div>
                        </div>';
                    }
                }
                if($a == false) echo '</div> <hr />';
            }
        }
    }
?>