<!DOCTYPE html>
<html lang="en">
<?php
$title = "Estimate";
$layout = $_POST["layoutType"] ?? 'grid';
$layout = $layout != '' ? $layout : 'grid';
include "./helpers/utils.php";
include "./layouts/header.php";
?>

<body>
    <style>
        body,
        p {
            overflow-x: hidden;
            color: #000 !important;
        }

        i.video {
            color: red;
        }

        img.video {
            width: 22px;
            cursor: video;
        }

        body:not(.fixedHeader) #header .container {
            margin: 0;
        }

      

        .spinner {
            display: inline-block;
            width: 12px;
            height: 12px;
            margin-left: 4px;
            vertical-align: -0.125em;
            border: 0.185em solid currentColor;
            border-right-color: transparent;
            border-radius: 50%;
            animation: 0.65s linear infinite spinner;
        }

        @keyframes spinner {
            to {
                transform: rotate(360deg)
                    /* rtl:ignore */
                ;
            }
        }

        .hide {
            display: none !important;
        }

        .total-display {
            border: none;
            display: -webkit-inline-box;
            background: none;
            position: absolute;
            right: 0;
            bottom: 1em;
            top: 3.5em;
            padding: 0;
            width: 100px !important;
            margin: 0;
        }

        .total-total {
            border: none;
            background: red;
            width: 50%;
            position: absolute;
            right: 0;
        }

        iframe {
            width: 100%;
            height: 320px;
            border-radius: 8px;
        }

        .op {
            opacity: 1 !important;
            visibility: visible !important;
        }

        .alert {
            position: fixed;
            top: 100px;
            width: 85%;
            background: #e50268;
            left: 50%;
            transform: translateX(-50%);
            z-index: 999999;
            text-align: center;
            border-radius: 10px;
            padding: 10px 0;
            margin: 0;
            border: 3px solid #e50268;
            opacity: 0;
            visibility: hidden;
        }

        .form-control {
            border: 1px solid #0000002e;
            border-radius: 8px;
            padding: 10px;
        }

        .form-control:focus {
            border-color: #3d3d3d !important;
        }

        .alert h5 {
            margin: 0;
            letter-spacing: 0.01em;
            font-family: cursive;
            padding: 0;
            color: #fff;
            font-size: 18px;
        }

        .alert p {
            float: right;
            position: absolute;
            top: 50%;
            right: 20px;
            transform: translateY(-50%);
            font-weight: 600;
            font-family: cursive;
            color: #ff4135;
            cursor: pointer;
        }

        .layout-options button {
            display: inline-block;
            width: 140px;
            padding: 0;
            margin: 10px;
            line-height: normal;
            border-radius: 8px;
            background: var(--primary-disabled-color);
            border: none;
            padding: 8px;
            color: var(--text-disabled-color);
            font-weight: 600;
        }

        .layout-options button.active {
            background: var(--primary-color);
            color: var(--text-color);
        }

        .total-bar {
            position: fixed;
            background: #fdeabf;
            bottom: 0;
            width: 100%;
            z-index: 999;
            padding: 10px;
            text-align: center;
            font-size: 14px;
            font-weight: 600;
            color: var(--primary-color);
        }
        
        .product .panel-body .minus,
        .product .panel-body .input-number,
        .product .panel-body .plus,
        

        .total-bar .show-cart {
            background: #FFFFFF;
            color: #000000;
        }

        .total-bar button {
            border-radius: 10px;
            background: transparent;
            margin: 0 0 0 20px;
            border: 1px solid var(--primary-color);
            padding: 2px 14px;
            letter-spacing: .5px;
            color: var(--primary-color);
        }

        .infos h3 s {

            font-size: 10px;
            font-weight: 600;

        }

        i.fa.fa-youtube-play {
            color: #3cbadf;
            font-size: 22px;
        }

        .msg h2 {
            font-size: 50px;
            color: #e50268;
            /*-webkit-text-stroke: 2px #f3bd00;*/
            text-shadow: 0px 0px 6px #00000091;
        }

        .discount h4 {
            font-size: 50px;
            color: var(--red);
            font-family: 'Poppins';
        }

        .back-to-top {
            bottom: 60px;
        }

        .whats-icon {
            bottom: 120px !important;
        }

        .phn-icon {
            bottom: 180px !important;
        }


        @media (max-width: 840px) {
            .alert h5 {
                font-size: 14px;
            }

            #main-cart {
                bottom: 80px !important;
            }
        }

        @media only screen and (max-width: 767px) {
            .mainmenu {
                z-index: 99;
            }
        }

        @media screen and (max-width: 715px) {

            .whatsapp,
            .mobile {
                display: none;
            }

            .discount h4 {
                font-size: 32px;
            }
        }

        @media screen and (max-width: 540px) {
            .cart-button {
                bottom: 6%;
            }

            .msg h2 {
                font-size: 30px;
            }
        }

        .bottom-bar {
            position: fixed;
            top: -30%;
            width: 100%;
            z-index: 9999;
            padding: 10px;
            transition: top .8s;
        }
        
        .bottom-bar .relative {
            position: relative;
            background-color: #2fcbe0;
            border-radius: 10px;
            padding: 12px;
            color: #fff;
        }
        
        .bottom-bar .message {
            font-size: 14px;
            line-height: 1.5;
        }

        .bottom-bar .link {
            display: inline-block;
            width: 100%;
            text-align: center;
            background-color: #d1005b;
            color: #fff;
            padding: 10px;
            border-radius: 8px;
        }
        
        .bottom-bar.fetched button.link,
        .bottom-bar.fetching a.link {
            display: none;
        }
    </style>
    <?php include "./layouts/navbar.php"; ?>

    <?php
    include './widgets/breadcrumb.php';
    ?>
    <div class="container-xxl py-4 gallery estimate">
        <div <?= $layout != "list" ? "class='container'" : ''  ?>>
            <?php
            include './helpers/configs.php';
            if (isset($min) && ($min != '0')) {
                //echo '<div class="msg text-center">
                  //  <h4>Judah Fireworks</h4>
                   // <h2>Order Closed</h2>
                    //<hr>
               // </div>';
                 echo '<div class="msg text-center">
                     <h4>Minimum Estimate</h4>
                    <h2>Rs.' . $min . '/- Only</h2>
                    (Karnataka, Andhrapradesh, Telengana Minimum 5000)
                </div>';
            }
            echo '<div class="alert">
                        <h5>Make order for minimum Rs.' . $min . '</h5>
                        <p onclick="closeAlert()">X</p>
                    </div>';
            if ($layout == "grid") {
                include './helpers/estimates/grid-view.php';
            } else if ($layout == "list") {
                include './helpers/estimates/list-view.php';
            } else {
                include './helpers/estimates/card-view.php';
            }
            ?>
        </div>
    </div>
    <div class="total-bar">
        Total Price: Rs. <span>0.00</span>
        <button class="show-cart">View Estimate</button>
    </div>

    <div class="modal fade data-box" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                </div>
                <div class="modal-body">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn close-modal btn-secondary">Close</button>
                    <button type="button" class="mt-0 estimate hide btn btn-primary">Estimate Now</button>
                </div>
            </div>
        </div>
    </div>

    <div class="bottom-bar fetching">
        <div class="relative">
            <h5 class="message">Thanks, Your order received! Please wait we'll reach you soon</h5>
            <button class="link">
                <i class="spinner"></i> Preparing File
            </button>
            <a href="" target="_blank" class="link">Download</a>
        </div>
    </div>
    <?php
    include "./layouts/footer.php";
    include "./layouts/scripts.php";
    ?>
    <script>
        $('ddocument').ready(() => {
            $('.layout-options button').each(function() {
                $(this).click(() => {
                    const {
                        value = "card"
                    } = $(this).data()
                    $('.layout-form input').val(value);
                    setTimeout(() => {
                        $('.layout-form').submit();
                    });
                })
            })
            $('.close-modal').click(() => {
                $('.modal').modal('hide')
            })
        })

        function formatPrice(price) {
            let str = price.split(',');
            a = '';
            str.forEach(s => {
                a += s;
            });
            return a;
        }

        function addDecimal(value) {
            value = value != undefined ? formatPrice(value.toString()) : 0;
            if (value > 0) a = Intl.NumberFormat("en-IN").format(value);
            else a = "0.00";

            return formatPrice(a.split(".").length > 1 ? a : a + ".00");
        }

        /** Numbers in words */
        var ones = [
            "",
            "One ",
            "Two ",
            "Three ",
            "Four ",
            "Five ",
            "Six ",
            "Seven ",
            "Eight ",
            "Nine ",
            "Ten ",
            "Eleven ",
            "Twelve ",
            "Thirteen ",
            "Fourteen ",
            "Fifteen ",
            "Sixteen ",
            "Seventeen ",
            "Eighteen ",
            "Nineteen ",
        ];
        var twos = [
            "",
            "",
            "Twenty",
            "Thirty",
            "Forty",
            "Fifty",
            "Sixty",
            "Seventy",
            "Eighty",
            "Ninety",
        ];

        function inWords(num) {
            num = Math.round(parseInt(formatPrice(num.toString())));
            if (num.length > 9) return "overflow";
            n = ("000000000" + num)
                .substr(-9)
                .match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (!n) return;
            var str = "";
            str +=
                n[1] != 0 ?
                (ones[Number(n[1])] || twos[n[1][0]] + " " + ones[n[1][1]]) + "Crore " :
                "";
            str +=
                n[2] != 0 ?
                (ones[Number(n[2])] || twos[n[2][0]] + " " + ones[n[2][1]]) + "Lakh " :
                "";
            str +=
                n[3] != 0 ?
                (ones[Number(n[3])] || twos[n[3][0]] + " " + ones[n[3][1]]) +
                "Thousand " :
                "";
            str +=
                n[4] != 0 ?
                (ones[Number(n[4])] || twos[n[4][0]] + " " + ones[n[4][1]]) + "Hundred " :
                "";
            str +=
                n[5] != 0 ?
                (str != "" ? "and " : "") +
                (ones[Number(n[5])] || twos[n[5][0]] + " " + ones[n[5][1]]) +
                "Only " :
                "";
            return str;
        }
        /** */

        $('.product').each(function() {
            let name = $(this).find('.name').html();
            $(this).find('.plus').click((e) => {
                e.preventDefault();
                let val = parseFloat($(this).find('[name="quantity"]').val()) || 0;
                val = val + 1;
                $(this).find('[name="quantity"]').val(val > -1 ? val : 0);
                $(this).find('[name="total"]').val(addDecimal(val * parseFloat(formatPrice($(this).find(
                    '.price').html()))))
                total();
            })
            $(this).find('.minus').click((e) => {
                e.preventDefault();
                let val = parseFloat($(this).find('[name="quantity"]').val()) || 0;
                val = val - 1;
                $(this).find('[name="quantity"]').val(val > -1 ? val : 0);
                $(this).find('[name="total"]').val(addDecimal(val * parseFloat(formatPrice($(this).find(
                    '.price').html()))))
                total();
            })
            $(this).find('[name="quantity"]').change((e) => {
                let val = parseFloat($(this).find('[name="quantity"]').val()) || 0;
                $(this).find('[name="total"]').val(addDecimal(val * parseFloat(formatPrice($(this).find(
                    '.price').html()))))
                total();
            })
            $(this).find('[name="quantity"]').keyup((e) => {
                let val = parseFloat($(this).find('[name="quantity"]').val()) || 0;
                $(this).find('[name="total"]').val(addDecimal(val * parseFloat(formatPrice($(this).find(
                    '.price').html()))))
                total();
            })
            $(this).find('.video').click(() => {
                $('.modal.data-box .modal-title').html(`${name} | Judah Fireworks`)
                let url = $(this).data('video');
                if (url.includes('/')) {
                    url = url.split('/').pop();
                }
                $('.modal.data-box .modal-body').html(
                    `<iframe src="https://www.youtube.com/embed/${url}" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>`
                )
                setTimeout(() => {
                    $('.modal.data-box').modal('show');
                }, 100);
            })
            $(this).find('.img').click(() => {
                $('.modal.data-box .modal-title').html(`${name} | Judah Fireworks`)
                $('.modal.data-box .modal-body').html(`<p class="text-center">
                <img style="width: 75%" src="${$(this).data('img')}"/>
            </p>`)
                setTimeout(() => {
                    $('.modal.data-box').modal('show');
                    $('button.estimate').addClass('hide');
                }, 100);
            })
        })

        total = () => {
            let val = 0;
            $('.product').each(function() {
                val = val + (parseFloat($(this).find('[name="total"]').val()) || 0);
            })
            $('.total-bar span').html(addDecimal((val.toFixed(2))))
            if (val > 0) {
                $('.cart-button').addClass('show-cart')
            } else {
                $('.cart-button').removeClass('show-cart')
            }
        }

        $('.show-cart').click((e) => {
            let body = '',
                totalPrice = 0,
                ordered = [];
            $('.product').each(function() {
                let price = addDecimal($(this).find('.price').html()),
                    total = addDecimal(Math.round(parseFloat(formatPrice($(this).find('[name="total"]')
                        .val())).toFixed(2))),
                    img = $(this).find('img').attr('src'),
                    name = $(this).find('.name').html(),
                    qty = parseInt($(this).find('[name="quantity"]').val());
                if (qty > 0) {
                    ordered.push({
                        "product": $(this).data('id'),
                        "name": name.replace('"', '\\"').replace("'", '\\"'),
                        "qty": qty,
                        "price": price,
                        "discount": $(this).data('discount'),
                        "total": total
                    })
                    body += `<tr class="item-row">
                    <td> <img src="${img}" width="30px" /></td>
                    <td>
                        <p> <strong>${name}</strong></p>
                    </td>
                    <td class="text-right" title="Amount">${qty}</td>
                    <td class="text-right" title="Price">${price}</td>
                    <td class="text-right" title="Total">${total}</td>
                </tr>`
                    totalPrice = totalPrice + parseFloat(total);
                }
            })
            $('.modal.data-box .modal-title').html('Judah Fireworks')
            $('.modal.data-box .modal-body').html(`<table class="table table-xs">
            <thead>
                <tr>
                    <th></th>
                    <th>Description</th>
                    <th class="text-right">Amount</th>
                    <th class="text-right">Price</th>
                    <th class="text-right">Total</th>
                </tr>
            </thead>
            <tbody>${body}</tbody>
            <tfoot>
                <tr class="total-row">
                    <td class="text-right" colspan="4">Total</td>
                    <td class="text-right total">${addDecimal(Math.round(parseFloat(totalPrice).toFixed(2)))}</td>
                </tr>
            </tfoot>
        </table>
        <form method="post" role="form" class="form p-3 php-email-form ">
            <div class="row">
            <div class="col-md-12 mb-2 form-group">
                        <input name="name" class="form-control" placeholder="Name" required="">
                    </div>
                    <div class="col-md-12 mb-2 form-group mt-3 mt-md-0">
                        <input maxlength="10" class="numonly form-control" name="email" type="number" placeholder="Mobile Number" required="">
                    </div>
                    <div class="col-md-12 mb-2 form-group mt-3 mt-md-0">
                        <input maxlength="10" class="numonly form-control" name="mobile" type="number" placeholder="Whatsapp Number" required="">
                    </div>
                    <div class="col-md-12 mb-2 form-group mt-3 mt-md-0">
                        <input class="form-control" name="city" placeholder="City" required="">
                    </div>
                    <div class="col-md-12 mb-2 form-group mt-3 mt-md-0">
                        <input class="form-control" name="address" placeholder="Delivery Point" required="">
                    </div>
            </div>
        </form>`)

            $(".numonly").on('input', function(e) {
                let val = e.target.value;
                if (val.length === 1) {
                    $(this).val(['6', '7', '8', '9'].includes(val) ? val : '');
                } else {
                    $(this).val(val.replace(/[^0-9]/g, ''));
                }
            });

            let min = parseInt("<?= $min ?>");

            if (totalPrice >= min && totalPrice > 0) {
                $('.alert').removeClass('op');
                setTimeout(() => {
                    $('.modal.data-box').modal('show');
                    $('.estimate').removeClass('hide');
                    $('.estimate').unbind("click");
                    $('.estimate').click((e) => {
                        e.preventDefault();

                        let name = $('.form [name="name"]').val();
                        let city = $('.form [name="city"]').val();
                        let district = $('.form [name="district"]').val();
                        let mobile = $('.form [name="mobile"]').val();
                        let email = $('.form [name="email"]').val();
                        if (name == '' || district == '' || email == '' || mobile == '' || city ==
                            '') {
                            $('.alert h5').html('Enter All details');
                            $('.alert').addClass('op');
                        } else if (mobile.length !== 10) {
                            $('.alert h5').html('Enter Valid Mobile Number');
                            $('.alert').addClass('op');
                        } else if (name != '' && city != '' && district != '' && mobile != '' &&
                            email !=
                            '') {
                            $.ajax({
                                type: "POST",
                                url: "<?= $admin ?>api/add-estimate/",
                                data: {
                                    products: ordered,
                                    customers: {
                                        "fname": $('.form [name="name"]').val(),
                                        "lname": "",
                                        "city": $('.form [name="address"]').val(),
                                        "city": $('.form [name="city"]').val(),
                                        "district": $('.form [name="district"]').val(),
                                        "mobile": $('.form [name="mobile"]').val(),
                                        "mail": $('.form [name="email"]').val(),
                                    },
                                    details: {
                                        "date": "<?= date('m/d/Y') ?>",
                                        "invoice_no": "",
                                        "discountType": "",
                                        "total": addDecimal(Math.round(totalPrice)),
                                        "mode": "Online",
                                        "extras": [],
                                        "word": inWords(addDecimal(Math.round(totalPrice)))
                                    },
                                    appId: <?= $app_id ?>
                                },
                                beforeSend: () => {
                                    $('.modal.data-box').modal('hide');
                                    $('.bottom-bar').css({
                                        top: `${($('.navbar').height() + $('.topbar').height())}px`
                                    })
                                },
                                success: ({estimateId}) => {
                                    if (estimateId != '') {
                                        $('.bottom-bar').removeClass('fetching').addClass('fetched');
                                        $('.bottom-bar a.link').attr('href',
                                            `<?= $admin ?>lib/pdf/exports?d=${estimateId}&t&id=<?= $app_id ?>`
                                            );
                                    } else {
                                        $('.bottom-bar').css({
                                            top: `-30%`
                                        })
                                    }
                                }
                            })
                        } else {
                            $('.alert h5').html('Enter All details');
                            $('.alert').addClass('op');
                        }
                    })
                }, 100);
            } else {
                if (totalPrice == 0) {
                    $('.alert h5').html(`Select Product!`);
                } else {
                    $('.alert h5').html(`Make order for minimum ${min}`);
                }
                $('.alert').addClass('op');
            }
        })
        closeAlert = () => {
            $('.alert').removeClass('op');
        }
        $('document').ready(() => {
            let heroCarousel = $(".hero-carousel");
            heroCarousel.owlCarousel({
                animateOut: 'slideOutUp',
                autoplay: true,
                autoplayTimeout: 500,
                smartSpeed: 1500,
                items: 1,
                loop: true,
                responsiveClass: true,
                responsive: {
                    0: {
                        dots: false,
                        nav: false
                    },
                    768: {
                        dots: false,
                        nav: false,

                    }
                },
                navText: [
                    '<i class="bi bi-chevron-left"></i>',
                    '<i class="bi bi-chevron-right"></i>'
                ]
            });
            // heroCarousel.on('changed.owl.carousel', function(event) {
            //     setTimeout(() => {
            //         let animationClasses = [
            //             "animate__flipInX", "animate__backInDown", "animate__bounceInDown", "animate__bounceInLeft",
            //             "animate__bounceInRight", "animate__bounceOutUp", "animate__fadeInDownBig", "animate__fadeInRight",
            //             "animate__fadeInUpBig", "animate__flipOutY", "animate__flipOutX", "animate__flipInY", "animate__flipInX",
            //             "animate__flip", "animate__lightSpeedInRight", "animate__lightSpeedInLeft", "animate__lightSpeedOutRight",
            //             "animate__jackInTheBox", "animate__rollIn", ""
            //         ];
            //         animationClasses.forEach((className) => {
            //             $('.owl-item').removeClass(`animate__animated ${className}`);
            //         });
            //         $('.owl-item.active').addClass(`animate__animated ${animationClasses[Math.floor(Math.random() * (animationClasses.length-1))]}`);
            //     }, 100);
            // });
        })
    </script>
</body>

</html>